/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	VillagerAttachmentInterface
**
** DESCRIPTION:	Interface for villager attachments
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef VILLAGER_ATTACHMENT_INTERFACE_H
#define VILLAGER_ATTACHMENT_INTERFACE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"

class CVillager;

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class IVillagerAttachment
{
	//interface methods
	//setup

	// process
	public:		virtual void Attach(const int iRef) {};
	public:		virtual void Remove(const int iRef) {};
	public:		virtual void Attach(CVillager &Villager, const int iRef, int &iTime) {};
	public:		virtual void Remove(CVillager &Villager, const int iRef) {};
	public:		virtual void Update(CVillager &Villager, const int iRef, const unsigned int uiElapsedTime) {};

	// access
	public:		virtual void SetPos(const int iRef, const ldwPoint sPos) {};
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/